/****** Object:  StoredProcedure [dbo].[usp_Insert_Discharge_Request]    Script Date: 03/22/2012 11:04:49 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_Insert_Discharge_Request]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_Insert_Discharge_Request]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		PII
-- Create date: 24.10.2012
-- Description:	Insert discharge request.
-- =============================================
CREATE PROCEDURE [dbo].[usp_Insert_Discharge_Request] 
	@ID	INT OUTPUT,
	@DOMAIN_ID VARCHAR(50),
	@IEN VARCHAR(50),
	@PATIENT_UID UNIQUEIDENTIFIER,
	@ORDERED_DATE DATETIME,
	@IS_ACTIVE BIT,
	@RELEASED_DATE DATETIME,
	@SIGNED_DATE DATETIME,
	@SIGNED_BY_UID UNIQUEIDENTIFIER,
	@PROVIDER_UID UNIQUEIDENTIFIER,
	@SCHEDULER_UID UNIQUEIDENTIFIER,
	@VISTA_SITE_UID UNIQUEIDENTIFIER,	
	@HOSPITAL_LOCATION_UID UNIQUEIDENTIFIER,	
	@ORDER_TEXT	VARCHAR(MAX),
	@ORDERABLE_ITEM_CODE VARCHAR(100),
	@ORDERABLE_ITEM_CODE_SYSTEM VARCHAR(100),
	@ORDERABLE_ITEM_CODE_SYSTEM_NAME VARCHAR(100),
	@ORDERABLE_ITEM_DISPLAY_NAME VARCHAR(250),
	@WARD_UID UNIQUEIDENTIFIER,
	@FACILITY_LIST VARCHAR(MAX)
AS
SET NOCOUNT ON

BEGIN

	DECLARE  @ORDERABLE_ITEM_ID INT
	-- ORDERABLE ITEM CONCEPT EXISTENCE CHECK
	EXEC dbo.usp_Manage_Concept 
		@CODE = @ORDERABLE_ITEM_CODE, 
		@CODE_SYSTEM = @ORDERABLE_ITEM_CODE_SYSTEM, 
		@CODE_SYSTEM_NAME = @ORDERABLE_ITEM_CODE_SYSTEM_NAME, 
		@DISPLAY_NAME = @ORDERABLE_ITEM_DISPLAY_NAME, 
		@ID = @ORDERABLE_ITEM_ID OUTPUT

	SELECT @ID = ID FROM DISCHARGE_REQ WHERE IEN = @IEN AND VISTA_SITE_UID = @VISTA_SITE_UID

	IF (@ID IS NULL)
		BEGIN	
			INSERT INTO DISCHARGE_REQ
				(DOMAIN_ID,
				IEN,
				PATIENT_UID ,
				ORDERED_DATE,
				IS_ACTIVE,
				RELEASED_DATE, 
				SIGNED_DATE, 
				SIGNED_BY_UID,
				SCHEDULER_UID, 
				PROVIDER_UID,
				VISTA_SITE_UID,
				HOSPITAL_LOCATION_UID,
				ORDER_TEXT,
				ORDERABLE_ITEM_ID,
				WARD_UID)
			VALUES
				(@DOMAIN_ID,
				@IEN,
				@PATIENT_UID,
				@ORDERED_DATE,
				@IS_ACTIVE,
				@RELEASED_DATE, 
				@SIGNED_DATE, 
				@SIGNED_BY_UID,
				@SCHEDULER_UID, 
				@PROVIDER_UID,
				@VISTA_SITE_UID,
				@HOSPITAL_LOCATION_UID,
				@ORDER_TEXT,
				@ORDERABLE_ITEM_ID,
				@WARD_UID)
			
			SET @ID = IDENT_CURRENT('dbo.DISCHARGE_REQ')

			INSERT INTO ORDER_FACILITY
				(ORDER_ID, FACILITY_UID, ORDER_TYPE)
			SELECT @ID, S.VALUE, 'DIS'
			FROM dbo.fn_Split(@FACILITY_LIST, ',') AS S
		END
END
GO
